<?php
header('Content-Type: application/json');
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: GET, POST');
header('Access-Control-Allow-Headers: Content-Type');

// ---------------- Config ----------------
$host = "localhost";              // Your database host
$user = "onesqeif_799";           // DB username
$pass = "!QJ{xhY5Dkz1";           // DB password
$dbname = "onesqeif_799";         // Database name

// Get JSON input
$input = json_decode(file_get_contents('php://input'), true);

if (!isset($input['attendance']) || !is_array($input['attendance'])) {
    http_response_code(400);
    echo json_encode(['success' => false, 'message' => 'Invalid attendance data']);
    exit();
}

// Create connection
$conn = new mysqli($host, $user, $pass, $dbname);

// Check connection
if ($conn->connect_error) {
    http_response_code(500);
    echo json_encode(['success' => false, 'message' => 'Database connection failed: ' . $conn->connect_error]);
    exit();
}

// Prepare SQL statement
$stmt = $conn->prepare("INSERT INTO attendance (user_id, date, time, status, color) VALUES (?, ?, ?, ?, ?)");
if (!$stmt) {
    http_response_code(500);
    echo json_encode(['success' => false, 'message' => 'Prepare failed: ' . $conn->error]);
    $conn->close();
    exit();
}

$stmt->bind_param("issss", $user_id, $date, $time, $status, $color);

$success_count = 0;
$error_count = 0;
$errors = [];

foreach ($input['attendance'] as $record) {
    $user_id = $record['user_id'];
    $date = $record['date'];
    $time = $record['time'] ?? null;
    $status = $record['status'];
    $color = $record['color'];
    
    if ($stmt->execute()) {
        $success_count++;
    } else {
        $error_count++;
        $errors[] = "User $user_id: " . $stmt->error;
    }
}

$stmt->close();
$conn->close();

if ($error_count > 0) {
    http_response_code(207); // Multi-status
    echo json_encode([
        'success' => false, 
        'message' => "Processed with errors: $success_count success, $error_count errors",
        'errors' => $errors
    ]);
} else {
    echo json_encode([
        'success' => true, 
        'message' => "Successfully processed $success_count attendance records"
    ]);
}
?>