<?php
require_once 'config.php';

class CronSync {
    private $conn;
    
    public function __construct() {
        try {
            $this->conn = new PDO(
                "mysql:host=" . Config::DB_HOST . ";dbname=" . Config::DB_NAME,
                Config::DB_USER,
                Config::DB_PASS
            );
        } catch(PDOException $e) {
            error_log("Cron DB Error: " . $e->getMessage());
            exit(1);
        }
    }
    
    public function syncUsers() {
        // Fetch users from API
        $ch = curl_init();
        curl_setopt_array($ch, [
            CURLOPT_URL => Config::USER_API_URL,
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_SSL_VERIFYPEER => false,
            CURLOPT_TIMEOUT => 30,
        ]);
        
        $response = curl_exec($ch);
        $httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
        curl_close($ch);
        
        if ($httpCode === 200) {
            $data = json_decode($response, true);
            if (isset($data['data'])) {
                foreach ($data['data'] as $user) {
                    $unique_id = $user['type'] . '_' . $user['uid'];
                    $stmt = $this->conn->prepare("
                        INSERT INTO users (user_id, name, phone, type, sync_status) 
                        VALUES (?, ?, ?, ?, 'pending') 
                        ON DUPLICATE KEY UPDATE name = VALUES(name)
                    ");
                    $stmt->execute([$unique_id, $user['name'], $user['phone'], $user['type']]);
                }
                error_log("Cron: Synced " . count($data['data']) . " users");
            }
        }
    }
}

// Run based on command line argument
if (php_sapi_name() === 'cli') {
    $action = $argv[1] ?? 'users';
    $cron = new CronSync();
    
    if ($action === 'users') {
        $cron->syncUsers();
    }
}
?>