<?php
// sync_at.php
header('Content-Type: application/json');
$expected_token = 'YOUR_SECRET_TOKEN';
$headers = getallheaders();
$auth = isset($headers['Authorization']) ? $headers['Authorization'] : '';

if ($auth !== 'Bearer '.$expected_token) {
    http_response_code(401);
    echo json_encode(['error'=>'unauthorized']);
    exit;
}

$raw = file_get_contents('php://input');
$data = json_decode($raw, true);
if (!isset($data['attendances'])) {
    http_response_code(400);
    echo json_encode(['error'=>'no attendances']);
    exit;
}

try {
    $pdo = new PDO('mysql:host=localhost;dbname=amsdb;charset=utf8mb4', 'dbuser', 'dbpass', [PDO::ATTR_ERRMODE=>PDO::ERRMODE_EXCEPTION]);
    $stmt = $pdo->prepare("INSERT INTO attendance (uid, user_id, timestamp, status, punch) VALUES (:uid,:user_id,:timestamp,:status,:punch)");
    $count = 0;
    foreach ($data['attendances'] as $a) {
        $stmt->execute([
            ':uid' => $a['uid'],
            ':user_id' => $a['user_id'],
            ':timestamp' => $a['timestamp'],
            ':status' => $a['status'],
            ':punch' => $a['punch']
        ]);
        $count++;
    }
    echo json_encode(['ok'=>true, 'inserted'=>$count]);
} catch (Exception $e) {
    http_response_code(500);
    echo json_encode(['error'=> $e->getMessage()]);
}
